/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy;

import com.floragunn.codova.config.templates.AttributeSource;
import com.floragunn.codova.config.templates.ExpressionEvaluationException;
import com.floragunn.codova.config.templates.Template;
import com.floragunn.codova.config.text.Pattern;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.dlsfls.legacy.EvaluatedDlsFlsConfig;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.floragunn.searchsupport.cstate.ComponentStateProvider;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;

@Deprecated
public class LegacyRoleBasedDocumentAuthorization
implements ComponentStateProvider {
    private static final Logger log = LogManager.getLogger(LegacyRoleBasedDocumentAuthorization.class);
    private final SgDynamicConfiguration<Role> roles;
    private final IndexNameExpressionResolver resolver;
    private final ClusterService clusterService;
    private final ComponentState componentState = new ComponentState("role_based_document_authorization");

    public LegacyRoleBasedDocumentAuthorization(SgDynamicConfiguration<Role> roles, IndexNameExpressionResolver resolver, ClusterService clusterService) {
        this.roles = roles;
        this.resolver = resolver;
        this.clusterService = clusterService;
        this.componentState.setInitialized();
        this.componentState.setConfigVersion(roles.getDocVersion());
    }

    public EvaluatedDlsFlsConfig getDlsFlsConfig(User user, ImmutableSet<String> mappedRoles, PrivilegesEvaluationContext context) throws PrivilegesEvaluationException {
        if (!this.containsDlsFlsConfig(mappedRoles)) {
            if (log.isDebugEnabled()) {
                log.debug("No fls or dls found for {}", (Object)user);
            }
            return EvaluatedDlsFlsConfig.EMPTY;
        }
        HashMap<String, Set<String>> dlsQueriesByIndex = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> flsFields = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> maskedFieldsMap = new HashMap<String, Set<String>>();
        HashSet<String> noDlsConcreteIndices = new HashSet<String>();
        HashSet<String> noFlsConcreteIndices = new HashSet<String>();
        HashSet<String> noMaskedFieldConcreteIndices = new HashSet<String>();
        for (Map.Entry entry : this.roles.getCEntries().entrySet()) {
            if (!mappedRoles.contains(entry.getKey())) continue;
            Role role = (Role)entry.getValue();
            for (Role.Index index : role.getIndexPermissions()) {
                for (Template indexPattern : index.getLegacyIndexPatterns()) {
                    int i;
                    String[] concreteIndices;
                    try {
                        concreteIndices = this.getResolvedIndexPatterns(user, (Template<Pattern>)indexPattern);
                    }
                    catch (ExpressionEvaluationException e) {
                        this.componentState.addLastException("get_dls_fls_config", (Throwable)e);
                        throw new PrivilegesEvaluationException("Error while evaluating index pattern template of role " + (String)entry.getKey() + ":\nPattern: " + indexPattern + "\nUser: " + user.toStringWithAttributes(), (Throwable)e);
                    }
                    if (index.getDls() != null) {
                        try {
                            String dls = index.getDls().renderToString((AttributeSource)user);
                            if (dls != null && dls.length() > 0) {
                                for (i = 0; i < concreteIndices.length; ++i) {
                                    dlsQueriesByIndex.computeIfAbsent(concreteIndices[i], key -> new HashSet()).add(dls);
                                }
                            }
                            noDlsConcreteIndices.addAll(Arrays.asList(concreteIndices));
                        }
                        catch (ExpressionEvaluationException e) {
                            this.componentState.addLastException("get_dls_fls_config", (Throwable)e);
                            throw new PrivilegesEvaluationException("Error while evaluating DLS query template of role " + (String)entry.getKey() + ":\nQuery template: " + index.getDls() + "\nUser: " + user.toStringWithAttributes(), (Throwable)e);
                        }
                    } else {
                        noDlsConcreteIndices.addAll(Arrays.asList(concreteIndices));
                    }
                    ImmutableList fls = index.getFls();
                    if (fls != null && fls.size() > 0) {
                        for (i = 0; i < concreteIndices.length; ++i) {
                            String ci = concreteIndices[i];
                            if (flsFields.containsKey(ci)) {
                                ((Set)flsFields.get(ci)).addAll(Sets.newHashSet((Iterable)fls.map(f -> f.getSource())));
                                continue;
                            }
                            flsFields.put(ci, new HashSet());
                            ((Set)flsFields.get(ci)).addAll(Sets.newHashSet((Iterable)fls.map(f -> f.getSource())));
                        }
                    } else {
                        noFlsConcreteIndices.addAll(Arrays.asList(concreteIndices));
                    }
                    ImmutableList maskedFields = index.getMaskedFields();
                    if (maskedFields != null && maskedFields.size() > 0) {
                        for (int i2 = 0; i2 < concreteIndices.length; ++i2) {
                            String ci = concreteIndices[i2];
                            if (maskedFieldsMap.containsKey(ci)) {
                                ((Set)maskedFieldsMap.get(ci)).addAll(Sets.newHashSet((Iterable)maskedFields.map(f -> f.getSource())));
                                continue;
                            }
                            maskedFieldsMap.put(ci, new HashSet());
                            ((Set)maskedFieldsMap.get(ci)).addAll(Sets.newHashSet((Iterable)maskedFields.map(f -> f.getSource())));
                        }
                        continue;
                    }
                    noMaskedFieldConcreteIndices.addAll(Arrays.asList(concreteIndices));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Index patterns with no dls queries attached: {} - They will be removed from {}", noDlsConcreteIndices, dlsQueriesByIndex.keySet());
            log.debug("Index patterns with no fls fields attached: {} - They will be removed from {}", noFlsConcreteIndices, flsFields.keySet());
            log.debug("Index patterns with no masked fields attached: {} - They will be removed from {}", noMaskedFieldConcreteIndices, maskedFieldsMap.keySet());
        }
        WildcardMatcher.wildcardRemoveFromSet(dlsQueriesByIndex.keySet(), noDlsConcreteIndices);
        WildcardMatcher.wildcardRemoveFromSet(flsFields.keySet(), noFlsConcreteIndices);
        WildcardMatcher.wildcardRemoveFromSet(maskedFieldsMap.keySet(), noMaskedFieldConcreteIndices);
        return new EvaluatedDlsFlsConfig(dlsQueriesByIndex, flsFields, maskedFieldsMap);
    }

    private boolean containsDlsFlsConfig(ImmutableSet<String> mappedRoles) {
        for (Map.Entry entry : this.roles.getCEntries().entrySet()) {
            String roleName = (String)entry.getKey();
            if (!mappedRoles.contains((Object)roleName)) continue;
            Role role = (Role)entry.getValue();
            for (Role.Index index : role.getIndexPermissions()) {
                if (!this.containsDlsFlsConfig(index)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean containsDlsFlsConfig(Role.Index index) {
        return index.getDls() != null || index.getFls() != null && index.getFls().size() != 0 || index.getMaskedFields() != null && index.getMaskedFields().size() != 0;
    }

    private String[] getResolvedIndexPatterns(User user, Template<Pattern> indexPattern) throws ExpressionEvaluationException {
        String unresolved = indexPattern.renderToString((AttributeSource)user);
        String[] resolved = this.resolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpandOpen(), new String[]{unresolved});
        if (resolved == null || resolved.length == 0) {
            return new String[]{unresolved};
        }
        return resolved;
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

